(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2005-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit import2_frameCsv;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  ComCtrls, Dialogs, ExtCtrls, StdCtrls, ActnList,

  TBXDkPanels, TB2Item, TBX, Menus,
  AntStringList, AntJvLinkLabel, AntJvExControls, AntJvEdit, AntJvSpin,

  MovieClass, import2_frame, import2_engines;

type
  TImportFrameCSV = class(TImportFrame)
    lblDelim: TLabel;
    edtDelim: TComboBox;
    lblQuote: TLabel;
    edtQuote: TComboBox;
    chkFirstLineHeaders: TCheckBox;
    edtLinebreaks: TComboBox;
    lblLinebreaks: TLabel;
    btnFieldsLoad: TTBXButton;
    btnFieldsSave: TTBXButton;
    procedure btnReloadClick(Sender: TObject);
    procedure chkFirstLineHeadersClick(Sender: TObject);
    procedure btnFieldsLoadClick(Sender: TObject);
    procedure btnFieldsSaveClick(Sender: TObject);
  private
  public
    constructor Create(Owner: TComponent; Engine: TImportEngine;
     const ImportType: string; CustomFieldsProperties: TCustomFieldsProperties);
    procedure LoadSettings; override;
    procedure SaveSettings; override;
  end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

{$R *.dfm}

uses
  ConstValues, Global, ProgramSettings, functions_tbx, functions_str, fields;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

constructor TImportFrameCSV.Create(Owner: TComponent; Engine: TImportEngine;
 const ImportType: string; CustomFieldsProperties: TCustomFieldsProperties);
begin
  inherited;
  LoadButtonIcon(btnFieldsLoad, ICON_FILEOPEN);
  LoadButtonIcon(btnFieldsSave, ICON_FILESAVE);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.btnReloadClick(Sender: TObject);
begin
  inherited;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.LoadSettings;
begin
  inherited;
  with Settings.rImport.rCsv do
  begin
    edtDelim.Text := Delim;
    edtQuote.Text := Quote;
    chkFirstLineHeaders.Checked := FirstLineHeaders;
    chkFirstLineHeadersClick(chkFirstLineHeaders);
    edtLinebreaks.Text := Linebreaks;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.SaveSettings;
begin
  inherited;
  with Settings.rImport.rCsv do
  begin
    FirstLineHeaders := chkFirstLineHeaders.Checked;
    Delim := edtDelim.Text;
    Quote := edtQuote.Text;
    Linebreaks := edtLinebreaks.Text;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.chkFirstLineHeadersClick(Sender: TObject);
begin
  chkAutoAssign.Enabled := chkFirstLineHeaders.Checked;
//  if not chkAutoAssign.Enabled then
//    chkAutoAssign.Checked := False;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.btnFieldsLoadClick(Sender: TObject);
var
  i, idx: Integer;
  f: string;
begin
  for i := 0 to lstPreview.Columns.Count - 1 do
  begin
    if i < Settings.rImport.rCsv.Fields.Count then
      f := Settings.rImport.rCsv.Fields[i]
    else
      f := '';
    if (f = strFieldPicture) or (f = strTagFieldPicture) then
      idx := fieldPicture
    else
    begin
      idx := strFields.IndexOf(f);
      if idx = -1 then
        idx := IndexText(f, strTagFields);
      if idx = -1 then
      begin
        idx := Properties.IndexOf(f);
        if idx <> -1 then
          idx := idx + customFieldLow;
      end
    end;
    if idx in VirtualFields then
      idx := -1;
    if idx = -1 then
      f := '';
    lstPreview.Columns[i].Tag := idx;
    lstPreview.Columns[i].Caption := f;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TImportFrameCSV.btnFieldsSaveClick(Sender: TObject);
var
  i, Last: Integer;
  f: string;
begin
  Last := -1;
  Settings.rImport.rCsv.Fields.Clear;
  for i := 0 to lstPreview.Columns.Count - 1 do
  begin
    //f := lstPreview.Columns[i].Caption;
    with lstPreview.Columns[i] do
    begin
      f := '';
      if Tag = fieldPicture then
        f := strTagFieldPicture
      else if (Tag > -1) and (Tag < fieldCount) then
        f := strTagFields[Tag]
      else if (Tag >= customFieldLow) and (Tag - customFieldLow < Properties.Count) then
        f := Properties.Objects[Tag - customFieldLow].FieldTag;
    end;
    Settings.rImport.rCsv.Fields.Add(f);
    if f <> '' then
      Last := i;
  end;
  while Settings.rImport.rCsv.Fields.Count - 1 > Last do
    Settings.rImport.rCsv.Fields.Delete(Last + 1);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.

